$fn=60;
wall_thickness=2.0;
pipes_extension=20.0;
main_l=74.0;
main_h=16.0;
main_w=11.5;

protub_l=32.5;
protub_offset=22.5;
protub_h=8.0;

level2hole1=6.26;
level2hole2=10.66;
level2wire=8.0;

level2screws=4.23;
between_screws=25.4;
screw1_offset=protub_offset+((protub_l-between_screws)/2.0);
screw2_offset=screw1_offset+between_screws;
screws_radius=3.2/2.0;

lightpipe_radius=3.0/2.0;
backwire_radius=4.5/2.0;


module negative_space() {
    cube([main_l,main_w,main_h+8.0
    ]);
    translate([protub_offset,0,-protub_h])cube([protub_l,main_w, protub_h]);
    translate([0,main_w/2.0,level2hole1])rotate([0,-90,0])cylinder(h=80,r=lightpipe_radius);
    translate([0,main_w/2.0,level2hole2])rotate([0,-90,0])cylinder(h=80,r=lightpipe_radius);
    translate([main_l,main_w/2.0,level2wire])rotate([0,90,0])cylinder(h=80,r=backwire_radius);
    translate([screw1_offset,-40.0+(main_w/2.0),-level2screws])rotate([-90,90,0])cylinder(h=80,r=screws_radius);
    translate([screw2_offset,-40.0+(main_w/2.0),-level2screws])rotate([-90,90,0])cylinder(h=80,r=screws_radius);translate([2-pipes_extension+screws_radius,-40.0+(main_w/2.0),0])rotate([-90,90,0])cylinder(h=80,r=screws_radius);    
}

module first_half(){
    translate([-wall_thickness-pipes_extension,-wall_thickness, -wall_thickness-protub_h])cube([pipes_extension+main_l+2*wall_thickness, main_w/2.0+wall_thickness,wall_thickness+protub_h+main_h]);
}

module second_half(){
    translate([-wall_thickness-pipes_extension,main_w/2.0, -wall_thickness-protub_h])cube([pipes_extension+main_l+2*wall_thickness, main_w/2.0+wall_thickness,wall_thickness+protub_h+main_h]);
}
    
rotate([90,0,0])difference(){
    first_half();
    negative_space();
}
translate([0,main_h+protub_h+2.0,main_w])rotate([-90,0,0])difference(){
    second_half();
    negative_space();
}
