$fn=360;

// Light sensitive resistor measurements
sensorBiggerDiam=5.2;
sensorSmallerDiam=4.5;
sensorThickness=2.2;
//wireDiam=0.5; // we'll use the ElectricWiresHoleDiam instead.
WireSeparation=2.5; // separation wall thickness


// light pipe measurements
lpDiam=3.15;
lpLensDiam=4.18;
lpLensLength=13.15;
lpLensCapDiam=5.1;
lpLensCapThickness=1.0;
minArcDiam=55;

// Some desired values
tolerance=0.4;
wallThickness=3.0;
ElectricWiresHoleDiam=3;
ElectricWiresHoleDiam2=23;
BoxL=80;
BoxW=34;
BoxH=8;
BoxXOffset=10;
LightBlockDiam=2;


//
//rotate_extrude(
        //angle=360,         angle
        //convexity=100)     complexity?
        //translate([4,0,0]) diam1
        //circle(r=1);       diam2




module mockupLightPipe(){
    rotate([0,90,0])cylinder(d=lpLensCapDiam+tolerance,h=lpLensCapThickness+tolerance);
    translate([lpLensCapThickness+tolerance,0,0])rotate([0,90,0])cylinder(d=lpLensDiam+tolerance,h=lpLensLength);
    translate([lpLensCapThickness+tolerance+lpLensLength,-minArcDiam, 0])
        rotate_extrude(angle=90,convexity=10)
            translate([minArcDiam,0,0])
                circle(d=lpDiam+tolerance);
}

module mockupPhotoResistor(){
    t=sensorThickness+tolerance;
    l=sensorBiggerDiam+tolerance;
    h=sensorSmallerDiam+tolerance;
    d=ElectricWiresHoleDiam;
    d2=ElectricWiresHoleDiam2;
    ws=WireSeparation-tolerance;
    translate([-t, -l/2,-h/2])cube([t,l,h]);
    translate([-t,d2,0])
        rotate([0,0,180])
            rotate_extrude(angle=90,convexity=10)
                union(){
                translate([d2+(d+ws)/2,0,0])
                    circle(d=d);
                translate([d2-(d+ws)/2,0,0])
                    circle(d=d);
                }
}



module seal(){
    l=BoxL;
    w=BoxW;
    h=BoxH/2;
    d=LightBlockDiam;
    xo=BoxXOffset;    
    translate([xo-l/2+d,-w/2+d,0])rotate([0,90,90])cylinder(d=d,h=w-2*d);
    translate([xo-l/2+d,w/2-d,0])rotate([0,90,0])cylinder(d=d,h=l-2*d);
    translate([xo-l/2+d,-w/2+d,0])rotate([0,90,0])cylinder(d=d,h=l-2*d);
    translate([xo+l/2-d,-w/2+d,0])rotate([0,90,90])cylinder(d=d,h=w-2*d);
}

module topCover(){    
    l=BoxL;
    w=BoxW;
    h=BoxH/2;
    d=LightBlockDiam;
    xo=BoxXOffset;    
    difference(){
        union(){
            translate([xo-l/2,-w/2,-h])cube([l,w,h]);
            seal();
        }
        mockupLightPipe();
        mockupPhotoResistor();
    }    
}
module BottomCover(){    
    l=BoxL;
    w=BoxW;
    h=BoxH/2;
    d=LightBlockDiam;
    xo=BoxXOffset;    
    difference(){
            translate([xo-l/2,-w/2,-h])cube([l,w,h]);
        seal();        
        translate([2*xo,0,0])
            rotate([0,180,0]) 
                union(){
                    mockupLightPipe();
                    mockupPhotoResistor();
                }
            }    
}



translate([0,BoxW/2+2,0])topCover();
translate([0,-BoxW/2-2,0])BottomCover();



