    $fn=360;

filmWidth=8
.0;





label=str("For ",filmWidth,"mm reels");
echo (label);

height = (35.0-filmWidth)/2.0 ;
centerDiameter = 40;
holeDiameter = 8.33;
numberOfArms = 8;
armWidth = 3;
outCirclesCount = 4;
circleThickness = armWidth;

diskRadius = centerDiameter / 2;
diskThickness = height;
armLength = 100 - (centerDiameter/2.0);



difference(){
    cylinder(d = centerDiameter, h = diskThickness);
    translate([0, 0, -1])
    cylinder(d = holeDiameter, h = height+2);
    translate([-14,-8,height-1 ])linear_extrude(height=2)text(label, size=3);
    translate([-13.5,5,height-1 ])linear_extrude(height=2)text("REEL RAISER", size=3);
    rotate([0,180,0]){
    translate([-14,-8,-1 ])linear_extrude(height=2)text(label, size=3);
    translate([-13.5,5,-1 ])linear_extrude(height=2)text("REEL RAISER", size=3);}
}
for (i = [0 : numberOfArms - 1]) {
    rotate([0, 0, i * 360 / numberOfArms])
    translate([diskRadius-3, -armWidth/2, 0])
    cube([armLength+3, armWidth, height]);
}



module externalCircle(outerDiam,thickness,h){
    difference(){
            cylinder(d=outerDiam, h=h);
            translate([0,0,-1])
                cylinder(d=outerDiam-thickness, h=h+2);
    }
}

for (i=[2:outCirclesCount]){
    externalCircle(centerDiameter+2*i*(armLength / outCirclesCount),armWidth, height);
}

cutWidth=34;
difference(){
externalCircle(centerDiameter+2*(armLength / outCirclesCount),2*armWidth, height+5);
    rotate([0,0,180/numberOfArms])
    translate([-100,-cutWidth/2, height])    
        cube([200,cutWidth,6]);
    rotate([0,0,90+180/numberOfArms])
    translate([-100,-cutWidth/2, height])    
        cube([200,cutWidth,6]);
}
